/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.entity.Button;
import com.work4games.entity.Mouse;
import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Content;
import com.work4games.handlers.Keys;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class WorldMenuState
extends GameState {
    private Mouse mouse;
    private ArrayList<Button> buttons;
    private int world = PlayerSave.getWorld();
    private boolean altpage;

    public WorldMenuState(GameStateManager gsm) {
        this.gsm = gsm;
        this.init();
    }

    @Override
    public void init() {
        this.mouse = new Mouse();
        this.buttons = new ArrayList();
        PlayerSave.setMode(1);
        PlayerSave.setTimeLimit(0.0);
        int i = 1;
        while (i < 6) {
            Button b = null;
            if (!this.altpage) {
                if (this.world == 1) {
                    b = new Button(14, "Level 1 - " + i, "Level", 180, 44, 128, 105 + i * 50, true);
                } else if (this.world == 2) {
                    b = new Button(14, "Level 2 - " + i, "Level", 180, 44, 128, 105 + i * 50, true);
                } else if (this.world == 3) {
                    b = new Button(14, "Level 3 - " + i, "Level", 180, 44, 128, 105 + i * 50, true);
                } else if (this.world == 4) {
                    b = new Button(14, "Level 4 - " + i, "Level", 180, 44, 128, 105 + i * 50, true);
                } else if (this.world == 5) {
                    b = new Button(14, "Level 5 - " + i, "Level", 180, 44, 128, 105 + i * 50, true);
                } else if (this.world == 6) {
                    b = new Button(14, "Level 6 - " + i, "Level", 180, 44, 128, 105 + i * 50, true);
                }
            } else if (this.world == 1) {
                b = new Button(14, "Level 1 - " + (i + 5), "Level", 180, 44, 128, 105 + i * 50, true);
            } else if (this.world == 2) {
                b = new Button(14, "Level 2 - " + (i + 5), "Level", 180, 44, 128, 105 + i * 50, true);
            } else if (this.world == 3) {
                b = new Button(14, "Level 3 - " + (i + 5), "Level", 180, 44, 128, 105 + i * 50, true);
            } else if (this.world == 4) {
                b = new Button(14, "Level 4 - " + (i + 5), "Level", 180, 44, 128, 105 + i * 50, true);
            } else if (this.world == 5) {
                b = new Button(14, "Level 5 - " + (i + 5), "Level", 180, 44, 128, 105 + i * 50, true);
            } else if (this.world == 6) {
                b = new Button(14, "Level 6 - " + (i + 5), "Level", 180, 44, 128, 105 + i * 50, true);
            }
            this.buttons.add(b);
            ++i;
        }
        Button b2 = new Button(14, "BACK", 180, 44, 440, 430, true);
        this.buttons.add(b2);
        Button b3 = new Button(15, "Right Arrow", 24, 30, 215, 420, false);
        this.buttons.add(b3);
        Button b4 = new Button(16, "Left Arrow", 24, 30, 175, 420, false);
        this.buttons.add(b4);
        this.greyLevels();
    }

    @Override
    public void update() {
        this.handleInput();
        int i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            if (this.altpage) {
                if (b.getButtonID() == "Right Arrow") {
                    b.setGreyed(true);
                }
                if (b.getButtonID() == "Left Arrow") {
                    b.setGreyed(false);
                }
            } else {
                if (b.getButtonID() == "Right Arrow") {
                    b.setGreyed(false);
                }
                if (b.getButtonID() == "Left Arrow") {
                    b.setGreyed(true);
                }
            }
            b.update();
            if (!b.getGreyed()) {
                if (b.intersects(this.mouse)) {
                    b.setHover(true);
                    if (this.mouse.getClicked()) {
                        if (b.getTag() == "Level") {
                            if (this.world == 1) {
                                PlayerSave.setMap("/Maps/World-1/" + b.getButtonID() + ".map");
                            } else if (this.world == 2) {
                                PlayerSave.setMap("/Maps/World-2/" + b.getButtonID() + ".map");
                            } else if (this.world == 3) {
                                PlayerSave.setMap("/Maps/World-3/" + b.getButtonID() + ".map");
                            } else if (this.world == 4) {
                                PlayerSave.setMap("/Maps/World-4/" + b.getButtonID() + ".map");
                            } else if (this.world == 5) {
                                PlayerSave.setMap("/Maps/World-5/" + b.getButtonID() + ".map");
                            } else if (this.world == 6) {
                                PlayerSave.setMap("/Maps/World-6/" + b.getButtonID() + ".map");
                            }
                            this.gsm.setState(1);
                        } else if (b.getButtonID() == "Right Arrow") {
                            this.altpage = true;
                            this.init();
                        } else if (b.getButtonID() == "Left Arrow") {
                            this.altpage = false;
                            this.init();
                        } else if (b.getButtonID() == "BACK") {
                            this.gsm.setState(3);
                        }
                    }
                } else {
                    b.setHover(false);
                }
            }
            ++i;
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.WorldPlate, 320 - Content.WorldPlate.getWidth() / 2, 40, null);
        g.setColor(Color.WHITE);
        g.setFont(this.gsm.ipixelu);
        g.drawImage((Image)Content.WorldMenu, 250, 130, null);
        g.drawImage((Image)Content.PageMenu, 27, 395, null);
        if (this.world == 1) {
            this.gsm.drawCenteredString("WORLD 1", 320, 70, g);
        } else if (this.world == 2) {
            this.gsm.drawCenteredString("WORLD 2", 320, 70, g);
        } else if (this.world == 3) {
            this.gsm.drawCenteredString("WORLD 3", 320, 70, g);
        } else if (this.world == 4) {
            this.gsm.drawCenteredString("WORLD 4", 320, 70, g);
        } else if (this.world == 5) {
            this.gsm.drawCenteredString("WORLD 5", 320, 70, g);
        } else if (this.world == 6) {
            this.gsm.drawCenteredString("WORLD 6", 320, 70, g);
        }
        g.setFont(this.gsm.pixelFont20);
        int m = 0;
        if (this.altpage) {
            m = 5;
        }
        int i = 0;
        while (i < 5) {
            g.drawImage((Image)Content.Star[0], 260, 135 + 50 * i, null);
            g.drawString("Star:               Score: " + PlayerSave.getHighScore(this.world, i + 1 + m), 360, 162 + 50 * i);
            ++i;
        }
        g.setFont(this.gsm.pixelFont22);
        if (!this.altpage) {
            g.drawString("Page 1/2", 40, 430);
        } else {
            g.drawString("Page 2/2", 40, 430);
        }
        this.drawStars(g);
        this.drawLevelReq(g);
        i = 0;
        while (i < this.buttons.size()) {
            Button b = this.buttons.get(i);
            b.draw(g);
            ++i;
        }
        this.mouse.draw(g);
    }

    public void drawLevelReq(Graphics2D g) {
        if (!this.altpage) {
            int i = 1;
            while (i < 6) {
                g.drawString("x " + PlayerSave.getLevelReq(this.world, i), 305, 165 + (i - 1) * 50);
                ++i;
            }
        } else {
            int i = 6;
            while (i < 11) {
                g.drawString("x " + PlayerSave.getLevelReq(this.world, i), 305, 165 + (i - 6) * 50);
                ++i;
            }
        }
    }

    public void drawStars(Graphics2D g) {
        int m = 0;
        if (this.altpage) {
            m = 5;
        }
        int i = 1;
        while (i < 6) {
            int a;
            int b;
            int c;
            if (PlayerSave.getLevelStars(this.world, i + m) == 0) {
                c = 1;
                b = 1;
                a = 1;
            } else if (PlayerSave.getLevelStars(this.world, i + m) == 1) {
                a = 0;
                c = 1;
                b = 1;
            } else if (PlayerSave.getLevelStars(this.world, i + m) == 2) {
                b = 0;
                a = 0;
                c = 1;
            } else {
                c = 0;
                b = 0;
                a = 0;
            }
            g.drawImage((Image)Content.StarS[a], 420, 145 + (i - 1) * 50, null);
            g.drawImage((Image)Content.StarS[b], 440, 145 + (i - 1) * 50, null);
            g.drawImage((Image)Content.StarS[c], 460, 145 + (i - 1) * 50, null);
            ++i;
        }
    }

    public void greyLevels() {
        int m = 0;
        if (this.altpage) {
            m = 5;
        }
        int j = 0;
        while (j < this.buttons.size()) {
            Button b = this.buttons.get(j);
            int i = 1 + m;
            while (i < 6 + m) {
                if (b.getButtonID().equals("Level " + this.world + " - " + i) && PlayerSave.getTotalStars() < PlayerSave.getLevelReq(this.world, i)) {
                    b.setGreyed(true);
                }
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void handleInput() {
        this.mouse.update();
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(3);
        }
    }
}

